/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.Actionable;
import appeng.api.config.LockCraftingMode;
import appeng.api.config.Settings;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.helpers.iface.PatternProviderLogic;
import appeng.helpers.iface.PatternProviderLogicHost;
import appeng.parts.crafting.PatternProviderPart;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.SavedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class PatternProviderLockModePlots {
    private static final BlockPos LEVER_POS = BlockPos.f_121853_.m_142126_();
    private static final BlockPos BUTTON_POS = BlockPos.f_121853_.m_142125_();
    private static final GenericStack ONE_PLANK = new GenericStack(AEItemKey.of((ItemLike)Blocks.f_50705_), 1L);
    private static final GenericStack TWO_PLANK = new GenericStack(AEItemKey.of((ItemLike)Blocks.f_50705_), 2L);

    private PatternProviderLockModePlots() {
    }

    @TestPlot(value="pp_block_lockmode_pulse")
    public static void testBlockLockModePulse(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_UNTIL_PULSE);
        PatternProviderLockModePlots.testLockModePulse(plot);
    }

    @TestPlot(value="pp_part_lockmode_pulse")
    public static void testPartLockModePulse(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_UNTIL_PULSE);
        PatternProviderLockModePlots.testLockModePulse(plot);
    }

    private static void testLockModePulse(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            helper.m_177425_().m_177546_(1, () -> {
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
            }).m_177546_(1, () -> {
                helper.m_177421_(LEVER_POS);
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
                helper.m_177421_(LEVER_POS);
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
            }).m_177546_(1, () -> {
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
                helper.m_177385_(BUTTON_POS);
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should succeed");
            }).m_177546_(1, () -> {
                KeyCounter counter = helper.countContainerContentAt(BlockPos.f_121853_.m_7494_());
                helper.assertEquals(BlockPos.f_121853_.m_7494_(), 3L, counter.get(AEItemKey.of((ItemLike)Blocks.f_49999_)));
            }).m_177543_();
        });
    }

    @TestPlot(value="pp_block_lockmode_high")
    public static void testBlockLockModeHigh(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_WHILE_HIGH);
        PatternProviderLockModePlots.testLockModeHigh(plot);
    }

    @TestPlot(value="pp_part_lockmode_high")
    public static void testPartLockModeHigh(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_WHILE_HIGH);
        PatternProviderLockModePlots.testLockModeHigh(plot);
    }

    private static void testLockModeHigh(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            helper.m_177425_().m_177546_(1, () -> {
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed (1st attempt)");
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed (2nd attempt)");
            }).m_177546_(1, () -> {
                helper.m_177421_(LEVER_POS);
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_WHILE_HIGH, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
                helper.m_177421_(LEVER_POS);
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed (2nd attempt)");
            }).m_177546_(1, () -> {
                KeyCounter counter = helper.countContainerContentAt(BlockPos.f_121853_.m_7494_());
                helper.assertEquals(BlockPos.f_121853_.m_7494_(), 4L, counter.get(AEItemKey.of((ItemLike)Blocks.f_49999_)));
            }).m_177543_();
        });
    }

    @TestPlot(value="pp_block_lockmode_low")
    public static void testBlockLockModeLow(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_WHILE_LOW);
        PatternProviderLockModePlots.testLockModeLow(plot);
    }

    @TestPlot(value="pp_part_lockmode_low")
    public static void testPartLockModeLow(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_WHILE_LOW);
        PatternProviderLockModePlots.testLockModeLow(plot);
    }

    private static void testLockModeLow(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            helper.m_177425_().m_177546_(1, () -> {
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_WHILE_LOW, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
            }).m_177546_(1, () -> {
                helper.m_177421_(LEVER_POS);
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed (2nd attempt)");
                helper.m_177421_(LEVER_POS);
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_WHILE_LOW, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
            }).m_177546_(1, () -> {
                KeyCounter counter = helper.countContainerContentAt(BlockPos.f_121853_.m_7494_());
                helper.assertEquals(BlockPos.f_121853_.m_7494_(), 2L, counter.get(AEItemKey.of((ItemLike)Blocks.f_49999_)));
            }).m_177543_();
        });
    }

    @TestPlot(value="pp_block_lockmode_result")
    public static void testBlockLockModeResult(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_UNTIL_RESULT);
        PatternProviderLockModePlots.testLockModeResult(plot);
    }

    @TestPlot(value="pp_part_lockmode_result")
    public static void testPartLockModeResult(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_UNTIL_RESULT);
        PatternProviderLockModePlots.testLockModeResult(plot);
    }

    private static void testLockModeResult(PlotBuilder plot) {
        plot.storageDrive(BlockPos.f_121853_.m_142128_());
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            helper.m_177425_().m_177546_(1, () -> {
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should not fail");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                GenericStack expectedResult = TWO_PLANK;
                helper.assertEquals(BlockPos.f_121853_, expectedResult, pp.getUnlockStack());
            }).m_177546_(1, () -> {
                pp.getReturnInv().insert(AEItemKey.of((ItemLike)Items.f_42647_), 1L, Actionable.SIMULATE, null);
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(BlockPos.f_121853_, TWO_PLANK, pp.getUnlockStack());
                pp.getReturnInv().insert(AEItemKey.of((ItemLike)Items.f_42647_), 1L, Actionable.MODULATE, null);
                helper.check(!pp.getReturnInv().isEmpty(), "Items should not be returned to the network immediately");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(BlockPos.f_121853_, TWO_PLANK, pp.getUnlockStack());
            }).m_177546_(1, () -> {
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(BlockPos.f_121853_, ONE_PLANK, pp.getUnlockStack());
            }).m_177562_(() -> pp.getReturnInv().insert(AEItemKey.of((ItemLike)Items.f_42647_), 1L, Actionable.MODULATE, null)).m_177546_(1, () -> {
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(BlockPos.f_121853_, null, pp.getUnlockStack());
            }).m_177546_(1, () -> {
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(BlockPos.f_121853_, TWO_PLANK, pp.getUnlockStack());
            }).m_177546_(1, () -> {
                KeyCounter counter = helper.countContainerContentAt(BlockPos.f_121853_.m_7494_());
                helper.assertEquals(BlockPos.f_121853_.m_7494_(), 2L, counter.get(AEItemKey.of((ItemLike)Blocks.f_49999_)));
            }).m_177543_();
        });
    }

    @TestPlot(value="pp_part_wait_for_pulse_saved")
    public static void testPartWaitForPulseSaved(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_UNTIL_PULSE);
        PatternProviderLockModePlots.testWaitForPulseSaved(plot);
    }

    @TestPlot(value="pp_block_wait_for_pulse_saved")
    public static void testBlockWaitForPulseSaved(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_UNTIL_PULSE);
        PatternProviderLockModePlots.testWaitForPulseSaved(plot);
    }

    private static void testWaitForPulseSaved(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            SavedBlockEntity savedBe = new SavedBlockEntity((PlotTestHelper)((Object)helper));
            helper.m_177425_().m_177562_(() -> {
                helper.check(PatternProviderLockModePlots.pushPattern(host), "push pattern should succeed");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                savedBe.saveAndRemove(BlockPos.f_121853_);
            }).m_177546_(1, () -> savedBe.restore()).m_177546_(1, () -> {
                PatternProviderLogicHost newHost = PatternProviderLockModePlots.getHost(helper);
                PatternProviderLogic newPp = newHost.getLogic();
                helper.check(newPp != pp, "New pattern provider should not be the same as the old one");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)newPp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(newHost), "push pattern should fail");
            }).m_177543_();
        });
    }

    @TestPlot(value="pp_part_wait_for_result_saved")
    public static void testPartWaitForResultSaved(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_UNTIL_RESULT);
        PatternProviderLockModePlots.testWaitForResultSaved(plot);
    }

    @TestPlot(value="pp_block_wait_for_result_saved")
    public static void testBlockWaitForResultSaved(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_UNTIL_RESULT);
        PatternProviderLockModePlots.testWaitForResultSaved(plot);
    }

    private static void testWaitForResultSaved(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            SavedBlockEntity savedBe = new SavedBlockEntity((PlotTestHelper)((Object)helper));
            helper.m_177425_().m_177562_(() -> {
                helper.check(PatternProviderLockModePlots.pushPattern(host), "push pattern should succeed");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(BlockPos.f_121853_, TWO_PLANK, pp.getUnlockStack());
                savedBe.save(BlockPos.f_121853_);
                helper.m_177434_(BlockPos.f_121853_);
            }).m_177546_(1, () -> savedBe.restore()).m_177546_(1, () -> {
                PatternProviderLogicHost newHost = PatternProviderLockModePlots.getHost(helper);
                PatternProviderLogic newPp = newHost.getLogic();
                helper.check(newPp != pp, "New pattern provider should not be the same as the old one");
                helper.assertEquals(BlockPos.f_121853_, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)newPp.getCraftingLockedReason());
                helper.assertEquals(BlockPos.f_121853_, TWO_PLANK, pp.getUnlockStack());
                helper.check(!PatternProviderLockModePlots.pushPattern(newHost), "push pattern should fail");
            }).m_177543_();
        });
    }

    private static boolean pushPattern(PatternProviderLogicHost host) {
        IPatternDetails details = PatternProviderLockModePlots.createPatternDetails(host);
        KeyCounter[] inputs = new KeyCounter[]{new KeyCounter()};
        inputs[0].add(AEItemKey.of((ItemLike)Blocks.f_49999_), 1L);
        return host.getLogic().pushPattern(details, inputs);
    }

    private static PatternProviderLogicHost getHost(PlotTestHelper plotTestHelper) {
        BlockEntity be = plotTestHelper.m_177347_(BlockPos.f_121853_);
        if (be instanceof PatternProviderBlockEntity) {
            PatternProviderBlockEntity host = (PatternProviderBlockEntity)be;
            return host;
        }
        return plotTestHelper.getPart(BlockPos.f_121853_, Direction.UP, PatternProviderPart.class);
    }

    private static void setup(PlotBuilder plot, boolean usePart, LockCraftingMode mode) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin.m_7495_());
        if (!usePart) {
            plot.blockEntity(origin, AEBlocks.PATTERN_PROVIDER, host -> PatternProviderLockModePlots.setupPatternProvider(host, mode));
        } else {
            plot.cable(origin).part(Direction.UP, AEParts.PATTERN_PROVIDER, host -> PatternProviderLockModePlots.setupPatternProvider(host, mode)).facade(Direction.WEST, (ItemLike)Blocks.f_50069_).facade(Direction.EAST, (ItemLike)Blocks.f_50069_);
        }
        plot.buttonOn(BlockPos.f_121853_, Direction.WEST);
        plot.leverOn(BlockPos.f_121853_, Direction.EAST);
        plot.chest(origin.m_7494_(), new ItemStack[0]);
    }

    private static void setupPatternProvider(PatternProviderLogicHost host, LockCraftingMode mode) {
        PatternProviderLogic pp = host.getLogic();
        pp.getConfigManager().putSetting(Settings.LOCK_CRAFTING_MODE, mode);
        ItemStack pattern = PatternProviderLockModePlots.createPattern();
        pp.getPatternInv().addItems(pattern);
    }

    private static ItemStack createPattern() {
        return PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEItemKey.of((ItemLike)Blocks.f_49999_), 1L)}, new GenericStack[]{TWO_PLANK});
    }

    private static IPatternDetails createPatternDetails(PatternProviderLogicHost host) {
        return PatternDetailsHelper.decodePattern(PatternProviderLockModePlots.createPattern(), host.getBlockEntity().m_58904_());
    }
}

